<?php include 'partials/html.php' ?>

<head>
    <?php
    $title = "Img-Crop";
    include 'partials/title-meta.php' ?>

    <link href="assets/libs/cropperjs/cropper.min.css" rel="stylesheet" type="text/css" />

    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Top Bar Start -->
    <?php include 'partials/topbar.php' ?>
    <!-- Top Bar End -->
    <!-- leftbar-tab-menu -->
    <?php include 'partials/startbar.php' ?>
    <!-- end leftbar-tab-menu-->

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Image Crop</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">Dastone</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item"><a href="#">Forms</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item active">Image Crop</li>
                                </ol>
                            </div>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->
                <div class="row justify-content-center">
                    <div class="col-lg-9">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Image Cropper</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="img-container mb-0">
                                    <img id="image" src="assets/images/extra/card/img-1.jpg" alt="Picture">
                                </div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                        <div id="actions">
                            <div class="card docs-buttons">
                                <div class="card-body">
                                    <!-- <h3>Toolbar:</h3> -->
                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="setDragMode" data-option="move" title="Move">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;setDragMode&quot;, &quot;move&quot;)">
                                                <span class="fas fa-expand-arrows-alt"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="setDragMode" data-option="crop" title="Crop">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;setDragMode&quot;, &quot;crop&quot;)">
                                                <span class="fas fa-crop"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="zoom" data-option="0.1" title="Zoom In">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;zoom&quot;, 0.1)">
                                                <span class="fas fa-search-plus"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="zoom" data-option="-0.1" title="Zoom Out">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;zoom&quot;, -0.1)">
                                                <span class="fas fa-search-minus"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="move" data-option="-10" data-second-option="0" title="Move Left">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;move&quot;, -10, 0)">
                                                <span class="fas fa-arrow-left"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="move" data-option="10" data-second-option="0" title="Move Right">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;move&quot;, 10, 0)">
                                                <span class="fas fa-arrow-right"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="move" data-option="0" data-second-option="-10" title="Move Up">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;move&quot;, 0, -10)">
                                                <span class="fas fa-arrow-up"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="move" data-option="0" data-second-option="10" title="Move Down">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;move&quot;, 0, 10)">
                                                <span class="fa fa-arrow-down"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="rotate" data-option="-45" title="Rotate Left">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;rotate&quot;, -45)">
                                                <span class="fas fa-reply"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="rotate" data-option="45" title="Rotate Right">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;rotate&quot;, 45)">
                                                <span class="fas fa-share"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="scaleX" data-option="-1" title="Flip Horizontal">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;scaleX&quot;, -1)">
                                                <span class="fa fa-arrows-alt-h"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="scaleY" data-option="-1" title="Flip Vertical">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;scaleY&quot;, -1)">
                                                <span class="fas fa-arrows-alt-v"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="crop" title="Crop">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;crop&quot;)">
                                                <span class="fas fa-check"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="clear" title="Clear">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;clear&quot;)">
                                                <span class="fas fa-times"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="disable" title="Disable">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;disable&quot;)">
                                                <span class="fas fa-lock"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="enable" title="Enable">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;enable&quot;)">
                                                <span class="fas fa-unlock"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group mb-2 mr-1">
                                        <button type="button" class="btn btn-light" data-method="reset" title="Reset">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;reset&quot;)">
                                                <span class="fas fa-redo"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light btn-upload" title="Upload image file">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="Import image with Blob URLs">
                                                <span class="fas fa-upload"></span>
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-light" data-method="destroy" title="Destroy">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;destroy&quot;)">
                                                <span class="fas fa-power-off"></span>
                                            </span>
                                        </button>
                                    </div>

                                    <div class="btn-group btn-group-crop mb-2 mr-1">

                                        <button type="button" class="btn btn-primary" data-method="getCroppedCanvas" data-option="{ &quot;width&quot;: 160, &quot;height&quot;: 90 }">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getCroppedCanvas&quot;, { width: 160, height: 90 })">
                                                160&times;90
                                            </span>
                                        </button>
                                        <button type="button" class="btn btn-primary" data-method="getCroppedCanvas" data-option="{ &quot;width&quot;: 320, &quot;height&quot;: 180 }">
                                            <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getCroppedCanvas&quot;, { width: 320, height: 180 })">
                                                320&times;180
                                            </span>
                                        </button>
                                    </div>

                                    <!-- Show the cropped image in modal -->
                                    <div class="modal fade docs-cropped" id="getCroppedCanvasModal" aria-hidden="true" aria-labelledby="getCroppedCanvasTitle" role="dialog" tabindex="-1">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="getCroppedCanvasTitle">Cropped</h5>
                                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </button>
                                                </div>
                                                <div class="modal-body"></div>
                                                <div class="modal-footer">
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                                                    <a class="btn btn-primary" id="download" href="javascript:void(0);" download="cropped.jpg">Download</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div><!-- /.modal -->

                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="getData" data-option data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getData&quot;)">
                                            Get Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="setData" data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;setData&quot;, data)">
                                            Set Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="getContainerData" data-option data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getContainerData&quot;)">
                                            Get Container Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="getImageData" data-option data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getImageData&quot;)">
                                            Get Image Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="getCanvasData" data-option data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getCanvasData&quot;)">
                                            Get Canvas Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="setCanvasData" data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;setCanvasData&quot;, data)">
                                            Set Canvas Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="getCropBoxData" data-option data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;getCropBoxData&quot;)">
                                            Get Crop Box Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="setCropBoxData" data-target="#putData">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="$().cropper(&quot;setCropBoxData&quot;, data)">
                                            Set Crop Box Data
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="moveTo" data-option="0">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="cropper.moveTo(0)">
                                            Move to [0,0]
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="zoomTo" data-option="1">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="cropper.zoomTo(1)">
                                            Zoom to 100%
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="rotateTo" data-option="180">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="cropper.rotateTo(180)">
                                            Rotate 180°
                                        </span>
                                    </button>
                                    <button type="button" class="btn btn-secondary mb-2 mr-1" data-method="scale" data-option="-2" data-second-option="-1">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" title="cropper.scale(-2, -1)">
                                            Scale (-2, -1)
                                        </span>
                                    </button>
                                    <textarea class="form-control" id="putData" rows="3" placeholder="Get data to here or set data with this value"></textarea>
                                </div><!--end card-body-->
                            </div><!--end card-->
                        </div><!--end action-->
                    </div> <!--end col-->
                    <div class="col-lg-3">
                        <div class="card">
                            <div class="card-body">
                                <div class="docs-preview clearfix">
                                    <div class="img-preview preview-lg"></div>
                                    <div class="img-preview preview-md"></div>
                                    <div class="img-preview preview-sm"></div>
                                    <div class="img-preview preview-xs"></div>
                                </div>

                                <!-- <h3>Data:</h3> -->
                                <div class="docs-data">
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">X</span>
                                        <input type="text" class="form-control" id="dataX" placeholder="x">
                                        <span class="input-group-text">px</span>
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">Y</span>
                                        <input type="text" class="form-control" id="dataY" placeholder="y">
                                        <span class="input-group-text">px</span>
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">Width</span>
                                        <input type="text" class="form-control" id="dataWidth" placeholder="width">
                                        <span class="input-group-text">px</span>
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">Height</span>
                                        <input type="text" class="form-control" id="dataHeight" placeholder="height">
                                        <span class="input-group-text">px</span>
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">Rotate</span>
                                        <input type="text" class="form-control" id="dataRotate" placeholder="rotate">
                                        <span class="input-group-text">deg</span>
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">ScaleX</span>
                                        <input type="text" class="form-control" id="dataScaleX" placeholder="scaleX">
                                    </div>
                                    <div class="input-group mb-0">
                                        <span class="input-group-text">ScaleY</span>
                                        <input type="text" class="form-control" id="dataScaleY" placeholder="scaleY">
                                    </div>
                                </div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                        <div class="card docs-toggles">
                            <div class="card-body">
                                <div class="btn-group d-flex flex-nowrap" data-toggle="buttons">
                                    <label class="btn btn-light mb-1 active">
                                        <input type="radio" class="sr-only" id="aspectRatio0" name="aspectRatio" value="1.7777777777777777">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="aspectRatio: 16 / 9">
                                            16:9
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="aspectRatio1" name="aspectRatio" value="1.3333333333333333">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="aspectRatio: 4 / 3">
                                            4:3
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="aspectRatio2" name="aspectRatio" value="1">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="aspectRatio: 1 / 1">
                                            1:1
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="aspectRatio3" name="aspectRatio" value="0.6666666666666666">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="aspectRatio: 2 / 3">
                                            2:3
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="aspectRatio4" name="aspectRatio" value="NaN">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="aspectRatio: NaN">
                                            Free
                                        </span>
                                    </label>
                                </div>

                                <div class="btn-group d-flex flex-nowrap" data-toggle="buttons">
                                    <label class="btn btn-light mb-1 active">
                                        <input type="radio" class="sr-only" id="viewMode0" name="viewMode" value="0" checked>
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="View Mode 0">
                                            VM0
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="viewMode1" name="viewMode" value="1">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="View Mode 1">
                                            VM1
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="viewMode2" name="viewMode" value="2">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="View Mode 2">
                                            VM2
                                        </span>
                                    </label>
                                    <label class="btn btn-light mb-1">
                                        <input type="radio" class="sr-only" id="viewMode3" name="viewMode" value="3">
                                        <span class="docs-tooltip" data-bs-toggle="tooltip" data-animation="false" title="View Mode 3">
                                            VM3
                                        </span>
                                    </label>
                                </div>

                                <div class="dropdown dropup docs-options mt-2">
                                    <button type="button" class="btn btn-secondary dropdown-toggle w-100" id="toggleOptions" data-bs-toggle="dropdown" aria-expanded="true">
                                        Toggle Options
                                        <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="toggleOptions" role="menu">
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="responsive" type="checkbox" name="responsive" checked>
                                                <label class="form-check-label" for="responsive">responsive</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="restore" type="checkbox" name="restore" checked>
                                                <label class="form-check-label" for="restore">restore</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="checkCrossOrigin" type="checkbox" name="checkCrossOrigin" checked>
                                                <label class="form-check-label" for="checkCrossOrigin">checkCrossOrigin</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="checkOrientation" type="checkbox" name="checkOrientation" checked>
                                                <label class="form-check-label" for="checkOrientation">checkOrientation</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="modal" type="checkbox" name="modal" checked>
                                                <label class="form-check-label" for="modal">modal</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="guides" type="checkbox" name="guides" checked>
                                                <label class="form-check-label" for="guides">guides</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="center" type="checkbox" name="center" checked>
                                                <label class="form-check-label" for="center">center</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="highlight" type="checkbox" name="highlight" checked>
                                                <label class="form-check-label" for="highlight">highlight</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="background" type="checkbox" name="background" checked>
                                                <label class="form-check-label" for="background">background</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="autoCrop" type="checkbox" name="autoCrop" checked>
                                                <label class="form-check-label" for="autoCrop">autoCrop</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="movable" type="checkbox" name="movable" checked>
                                                <label class="form-check-label" for="movable">movable</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="rotatable" type="checkbox" name="rotatable" checked>
                                                <label class="form-check-label" for="rotatable">rotatable</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="scalable" type="checkbox" name="scalable" checked>
                                                <label class="form-check-label" for="scalable">scalable</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="zoomable" type="checkbox" name="zoomable" checked>
                                                <label class="form-check-label" for="zoomable">zoomable</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="zoomOnTouch" type="checkbox" name="zoomOnTouch" checked>
                                                <label class="form-check-label" for="zoomOnTouch">zoomOnTouch</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="zoomOnWheel" type="checkbox" name="zoomOnWheel" checked>
                                                <label class="form-check-label" for="zoomOnWheel">zoomOnWheel</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="cropBoxMovable" type="checkbox" name="cropBoxMovable" checked>
                                                <label class="form-check-label" for="cropBoxMovable">cropBoxMovable</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="cropBoxResizable" type="checkbox" name="cropBoxResizable" checked>
                                                <label class="form-check-label" for="cropBoxResizable">cropBoxResizable</label>
                                            </div>
                                        </li>
                                        <li class="dropdown-item">
                                            <div class="form-check">
                                                <input class="form-check-input" id="toggleDragModeOnDblclick" type="checkbox" name="toggleDragModeOnDblclick" checked>
                                                <label class="form-check-label" for="toggleDragModeOnDblclick">toggleDragModeOnDblclick</label>
                                            </div>
                                        </li>
                                    </ul>
                                </div><!-- /.dropdown -->

                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                </div><!--end row-->
            </div><!-- container -->
            <!--Start Rightbar-->
            <?php include 'partials/endbar.php' ?>
            <!--end Rightbar-->
            <!--Start Footer-->
            <?php include 'partials/footer.php' ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->

    <!-- Javascript  -->
    <!-- vendor js -->
    <?php include 'partials/vendorjs.php' ?>
    <script src="assets/libs/cropperjs/cropper.min.js"></script>
    <script src="assets/js/pages/crop.init.js"></script>
    <script src="assets/js/app.js"></script>
</body>
<!--end body-->

</html>