<?php include 'partials/html.php' ?>

<head>
  <?php
  $title = "Validation";
  include 'partials/title-meta.php' ?>

  <?php include 'partials/head-css.php' ?>
</head>

<body>
  <!-- Top Bar Start -->
  <?php include 'partials/topbar.php' ?>
  <!-- Top Bar End -->
  <!-- leftbar-tab-menu -->
  <?php include 'partials/startbar.php' ?>
  <!-- end leftbar-tab-menu-->

  <div class="page-wrapper">
    <!-- Page Content-->
    <div class="page-content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-sm-12">
            <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
              <h4 class="page-title">Validation</h4>
              <div class="">
                <ol class="breadcrumb mb-0">
                  <li class="breadcrumb-item"><a href="#">Dastone</a>
                  </li><!--end nav-item-->
                  <li class="breadcrumb-item"><a href="#">Forms</a>
                  </li><!--end nav-item-->
                  <li class="breadcrumb-item active">Validation</li>
                </ol>
              </div>
            </div><!--end page-title-box-->
          </div><!--end col-->
        </div><!--end row-->
        <div class="row justify-content-center">
          <div class="col-md-6 col-lg-6">
            <div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col">
                    <h4 class="card-title">Bootstrap Custom Styles</h4>
                  </div><!--end col-->
                </div> <!--end row-->
              </div><!--end card-header-->
              <div class="card-body">
                <form class="row g-3 needs-validation" novalidate>
                  <div class="col-md-4">
                    <label for="validationCustom01" class="form-label">First name</label>
                    <input type="text" class="form-control" id="validationCustom01" value="Mark" required>
                    <div class="valid-feedback">
                      Looks good!
                    </div>
                  </div>
                  <div class="col-md-4">
                    <label for="validationCustom02" class="form-label">Last name</label>
                    <input type="text" class="form-control" id="validationCustom02" value="Otto" required>
                    <div class="valid-feedback">
                      Looks good!
                    </div>
                  </div>
                  <div class="col-md-4">
                    <label for="validationCustomUsername" class="form-label">Username</label>
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend">@</span>
                      <input type="text" class="form-control" id="validationCustomUsername" aria-describedby="inputGroupPrepend" required>
                      <div class="invalid-feedback">
                        Please choose a username.
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <label for="validationCustom03" class="form-label">City</label>
                    <input type="text" class="form-control" id="validationCustom03" required>
                    <div class="invalid-feedback">
                      Please provide a valid city.
                    </div>
                  </div>
                  <div class="col-md-3">
                    <label for="validationCustom04" class="form-label">State</label>
                    <select class="form-select" id="validationCustom04" required>
                      <option selected disabled value="">Choose...</option>
                      <option>...</option>
                    </select>
                    <div class="invalid-feedback">
                      Please select a valid state.
                    </div>
                  </div>
                  <div class="col-md-3">
                    <label for="validationCustom05" class="form-label">Zip</label>
                    <input type="text" class="form-control" id="validationCustom05" required>
                    <div class="invalid-feedback">
                      Please provide a valid zip.
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="form-check">
                      <input class="form-check-input" type="checkbox" value="" id="invalidCheck" required>
                      <label class="form-check-label" for="invalidCheck">
                        Agree to terms and conditions
                      </label>
                      <div class="invalid-feedback">
                        You must agree before submitting.
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <button class="btn btn-primary" type="submit">Submit form</button>
                  </div>
                </form><!--end form-->
              </div><!--end card-body-->
            </div><!--end card-->
          </div> <!--end col-->
          <div class="col-md-6 col-lg-6">
            <div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col">
                    <h4 class="card-title">Validation Tooltips</h4>
                  </div><!--end col-->
                </div> <!--end row-->
              </div><!--end card-header-->
              <div class="card-body">
                <form class="row g-3 needs-validation" novalidate>
                  <div class="col-md-4 position-relative">
                    <label for="validationTooltip01" class="form-label">First name</label>
                    <input type="text" class="form-control" id="validationTooltip01" value="Mark" required>
                    <div class="valid-tooltip">
                      Looks good!
                    </div>
                  </div>
                  <div class="col-md-4 position-relative">
                    <label for="validationTooltip02" class="form-label">Last name</label>
                    <input type="text" class="form-control" id="validationTooltip02" value="Otto" required>
                    <div class="valid-tooltip">
                      Looks good!
                    </div>
                  </div>
                  <div class="col-md-4 position-relative">
                    <label for="validationTooltipUsername" class="form-label">Username</label>
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="validationTooltipUsernamePrepend">@</span>
                      <input type="text" class="form-control" id="validationTooltipUsername" aria-describedby="validationTooltipUsernamePrepend" required>
                      <div class="invalid-tooltip">
                        Please choose a unique and valid username.
                      </div>
                    </div>
                  </div>
                  <div class="col-md-6 position-relative">
                    <label for="validationTooltip03" class="form-label">City</label>
                    <input type="text" class="form-control" id="validationTooltip03" required>
                    <div class="invalid-tooltip">
                      Please provide a valid city.
                    </div>
                  </div>
                  <div class="col-md-3 position-relative">
                    <label for="validationTooltip04" class="form-label">State</label>
                    <select class="form-select" id="validationTooltip04" required>
                      <option selected disabled value="">Choose...</option>
                      <option>...</option>
                    </select>
                    <div class="invalid-tooltip">
                      Please select a valid state.
                    </div>
                  </div>
                  <div class="col-md-3 position-relative">
                    <label for="validationTooltip05" class="form-label">Zip</label>
                    <input type="text" class="form-control" id="validationTooltip05" required>
                    <div class="invalid-tooltip">
                      Please provide a valid zip.
                    </div>
                  </div>
                  <div class="col-12">
                    <button class="btn btn-primary" type="submit">Submit form</button>
                  </div>
                </form><!--end form-->
              </div><!--end card-body-->
            </div><!--end card-->
          </div> <!--end col-->
        </div><!--end row-->
        <div class="row">
          <div class="col-md-6 col-lg-6">
            <div class="card">
              <div class="card-header">
                <div class="row align-items-center">
                  <div class="col">
                    <h4 class="card-title">Custom Validation Form</h4>
                  </div><!--end col-->
                </div> <!--end row-->
              </div><!--end card-header-->
              <div class="card-body">
                <form id="form-validation-2" class="form">
                  <div class="mb-2">
                    <label for="username" class="form-label">Username</label>
                    <input class="form-control" type="text" id="username" placeholder="Enter Username">
                    <small>Error Message</small>
                  </div>
                  <div class="mb-2">
                    <label for="email" class="form-label">Email</label>
                    <input class="form-control" type="text" id="email" placeholder="Enter email">
                    <small>Error Message</small>
                  </div>
                  <div class="mb-2">
                    <label for="password" class="form-label">Password</label>
                    <input class="form-control" type="password" id="password" placeholder="Enter password">
                    <small>Error Message</small>
                  </div>
                  <div class="mb-3">
                    <label for="password2" class="form-label">Confirm Password</label>
                    <input class="form-control" type="password" id="password2" placeholder="Enter password again">
                    <small>Error Message</small>
                  </div>
                  <button type="submit" class="btn btn-primary">Submit form</button>
                </form><!--end form-->
              </div><!--end card-body-->
            </div><!--end card-->
          </div> <!--end col-->
        </div><!--end row-->
      </div><!-- container -->
      <!--Start Rightbar-->
      <?php include 'partials/endbar.php' ?>
      <!--end Rightbar-->
      <!--Start Footer-->
      <?php include 'partials/footer.php' ?>
      <!--end footer-->
    </div>
    <!-- end page content -->
  </div>
  <!-- end page-wrapper -->

  <!-- Javascript  -->
  <!-- vendor js -->
  <?php include 'partials/vendorjs.php' ?>
  <script src="assets/js/pages/form-validation.js"></script>
  <script src="assets/js/app.js"></script>
</body>
<!--end body-->

</html>