<?php include 'partials/html.php' ?>

<head>
    <?php
    $title = "Kanban";
    include 'partials/title-meta.php' ?>

    <link href="assets/libs/dragula/dragula.min.css" rel="stylesheet" type="text/css" />

    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Top Bar Start -->
    <?php include 'partials/topbar.php' ?>
    <!-- Top Bar End -->
    <!-- leftbar-tab-menu -->
    <?php include 'partials/startbar.php' ?>
    <!-- end leftbar-tab-menu-->

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Kanban</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">Dastone</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item"><a href="#">Projects</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item active">Kanban</li>
                                </ol>
                            </div>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->
                <div class="row">
                    <div class="col-lg-12">
                        <div class="kanban-board">
                            <div class="kanban-col">
                                <div class="my-3">
                                    <div class="d-flex justify-content-between align-items-center border-bottom border-pink">
                                        <div>
                                            <h6 class="fw-semibold fs-16 text-muted mb-1">To Do</h6>
                                            <h6 class="fs-13 fw-semibold">3 Issues - <span class="text-muted">20 Points</span></h6>
                                        </div>
                                        <div>
                                            <a class="text-secondary me-1 add-btn cursor-pointer" data-bs-toggle="modal" data-bs-target="#addtask">
                                                <i class="fa-solid fa-plus fs-18"></i>
                                            </a>
                                            <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                <i class="fa-solid fa-ellipsis fs-18"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </div><!--end /div-->

                                <div id="project-list-left" class="pt-1">
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Medium</span>
                                            <h5 class="my-2 fs-14">Simple Design</h5>
                                            <p class="text-muted mb-3 text-truncate">Contrary to popular belief, Lorem Ipsum is not simply random text.</p>
                                            <div class="d-flex justify-content-between fw-semibold align-items-center">
                                                <p class="mb-1 d-inline-flex align-items-center"><i class="iconoir-task-list fs-18 text-muted me-1"></i>14 Tasks</p>
                                                <small class="text-end text-body-emphasis d-block ms-auto">70%</small>
                                            </div>
                                            <div class="progress bg-secondary-subtle" style="height:3px;">
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 15% " aria-valuenow="15" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-file text-muted"></i>
                                                                <span class="text-muted fw-bold">5 Files</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-end">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->

                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-danger bg-danger-subtle fw-normal px-1 mb-1">High</span>
                                            <h5 class="my-2 fs-14">Strong Password</h5>
                                            <p class="text-muted mb-3 text-truncate">There are many variations of passages of Lorem Ipsum.</p>
                                            <div>
                                                <span class="badge rounded text-primary bg-primary-subtle fw-normal px-1 mb-1">API</span>
                                                <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Form Submit</span>
                                                <span class="badge rounded text-danger bg-danger-subtle fw-normal px-1 mb-1">Responsive</span>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-solid fa-list-check text-muted"></i>
                                                                <span class="text-muted fw-bold">0/5 Tasks</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-center">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-success bg-success-subtle fw-normal px-2 mb-1">Completed</span>
                                            <h5 class="my-2 fs-14">Multi Color Dashboard</h5>
                                            <p class="text-muted mb-0 text-truncate">It is a long established fact that a reader will be distracted.</p>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-solid fa-list-check text-muted"></i>
                                                                <span class="text-muted fw-bold">0/5 Tasks</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-center">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                </div><!--end project-list-left-->
                                <a href="" class="btn btn-sm btn-soft-primary w-100" data-bs-toggle="modal" data-bs-target="#addtask"> <i class="fa-solid fa-plus me-1"></i> Add New Task</a>
                            </div><!--end kanban-col-->
                            <div class="kanban-col">
                                <div class="my-3">
                                    <div class="d-flex justify-content-between align-items-center  border-bottom border-warning">
                                        <div>
                                            <h6 class="fw-semibold fs-16 text-muted mb-1">In Progress</h6>
                                            <h6 class="fs-13 fw-semibold">2 Issues - <span class="text-muted">8 Points</span></h6>
                                        </div>
                                        <div>
                                            <a class="text-secondary me-1 add-btn cursor-pointer" data-bs-toggle="modal" data-bs-target="#addtask">
                                                <i class="fa-solid fa-plus fs-18"></i>
                                            </a>
                                            <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                <i class="fa-solid fa-ellipsis fs-18"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </div><!--end /div-->
                                <div id="project-list-center-left" class="pt-1">
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-success bg-success-subtle fw-normal px-2 mb-1">Completed</span>
                                            <h5 class="my-2 fs-14">Multi Color Dashboard</h5>
                                            <p class="text-muted mb-0 text-truncate">It is a long established fact that a reader will be distracted.</p>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-solid fa-list-check text-muted"></i>
                                                                <span class="text-muted fw-bold">0/5 Tasks</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-center">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-danger bg-danger-subtle fw-normal px-1 mb-1">High</span>
                                            <h5 class="my-2 fs-14">Strong Password</h5>
                                            <p class="text-muted mb-3 text-truncate">There are many variations of passages of Lorem Ipsum.</p>
                                            <div>
                                                <span class="badge rounded text-primary bg-primary-subtle fw-normal px-1 mb-1">API</span>
                                                <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Form Submit</span>
                                                <span class="badge rounded text-danger bg-danger-subtle fw-normal px-1 mb-1">Responsive</span>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-solid fa-list-check text-muted"></i>
                                                                <span class="text-muted fw-bold">0/5 Tasks</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-center">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Medium</span>
                                            <h5 class="my-2 fs-14">Simple Design</h5>
                                            <p class="text-muted mb-3 text-truncate">Contrary to popular belief, Lorem Ipsum is not simply random text.</p>
                                            <div class="d-flex justify-content-between fw-semibold align-items-center">
                                                <p class="mb-1 d-inline-flex align-items-center"><i class="iconoir-task-list fs-18 text-muted me-1"></i>14 Tasks</p>
                                                <small class="text-end text-body-emphasis d-block ms-auto">70%</small>
                                            </div>
                                            <div class="progress bg-secondary-subtle" style="height:3px;">
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 15% " aria-valuenow="15" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-file text-muted"></i>
                                                                <span class="text-muted fw-bold">5 Files</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-end">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                </div><!--end project-list-left-->
                                <a href="" class="btn btn-sm btn-soft-primary w-100" data-bs-toggle="modal" data-bs-target="#addtask"> <i class="fa-solid fa-plus me-1"></i> Add New Task</a>
                            </div><!--end kanban-col-->
                            <div class="kanban-col">
                                <div class="my-3">
                                    <div class="d-flex justify-content-between align-items-center border-bottom border-success">
                                        <div>
                                            <h6 class="fw-semibold fs-16 text-muted mb-1">Review</h6>
                                            <h6 class="fs-13 fw-semibold">1 Issues - <span class="text-muted">7 Points</span></h6>
                                        </div>
                                        <div>
                                            <a class="text-secondary me-1 add-btn cursor-pointer" data-bs-toggle="modal" data-bs-target="#addtask">
                                                <i class="fa-solid fa-plus fs-18"></i>
                                            </a>
                                            <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                <i class="fa-solid fa-ellipsis fs-18"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </div><!--end /div-->
                                <div id="project-list-center-right" class="pt-1">
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-danger bg-danger-subtle fw-normal px-1 mb-1">High</span>
                                            <h5 class="my-2 fs-14">Strong Password</h5>
                                            <p class="text-muted mb-3 text-truncate">There are many variations of passages of Lorem Ipsum.</p>
                                            <div>
                                                <span class="badge rounded text-primary bg-primary-subtle fw-normal px-1 mb-1">API</span>
                                                <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Form Submit</span>
                                                <span class="badge rounded text-danger bg-danger-subtle fw-normal px-1 mb-1">Responsive</span>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-solid fa-list-check text-muted"></i>
                                                                <span class="text-muted fw-bold">0/5 Tasks</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-center">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Medium</span>
                                            <h5 class="my-2 fs-14">Simple Design</h5>
                                            <p class="text-muted mb-3 text-truncate">Contrary to popular belief, Lorem Ipsum is not simply random text.</p>
                                            <div class="d-flex justify-content-between fw-semibold align-items-center">
                                                <p class="mb-1 d-inline-flex align-items-center"><i class="iconoir-task-list fs-18 text-muted me-1"></i>14 Tasks</p>
                                                <small class="text-end text-body-emphasis d-block ms-auto">70%</small>
                                            </div>
                                            <div class="progress bg-secondary-subtle" style="height:3px;">
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 15% " aria-valuenow="15" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-file text-muted"></i>
                                                                <span class="text-muted fw-bold">5 Files</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-end">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                </div><!--end project-list-left-->
                                <a href="" class="btn btn-sm btn-soft-primary w-100" data-bs-toggle="modal" data-bs-target="#addtask"> <i class="fa-solid fa-plus me-1"></i> Add New Task</a>
                            </div><!--end kanban-col-->
                            <div class="kanban-col">
                                <div class="my-3">
                                    <div class="d-flex justify-content-between align-items-center border-bottom border-primary">
                                        <div>
                                            <h6 class="fw-semibold fs-16 text-muted mb-1">Done</h6>
                                            <h6 class="fs-13 fw-semibold">5 Issues - <span class="text-muted">12 Points</span></h6>
                                        </div>
                                        <div>
                                            <a class="text-secondary me-1 add-btn cursor-pointer" data-bs-toggle="modal" data-bs-target="#addtask">
                                                <i class="fa-solid fa-plus fs-18"></i>
                                            </a>
                                            <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                <i class="fa-solid fa-ellipsis fs-18"></i>
                                            </a>
                                            <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                            </div>
                                        </div>
                                    </div>
                                </div><!--end /div-->
                                <div id="project-list-right" class="pt-1">
                                    <div class="card mb-3">
                                        <div class="card-body">
                                            <div class="dropdown d-inline-block float-end">
                                                <a class="dropdown-toggle arrow-none text-secondary" data-bs-toggle="dropdown" href="#" role="button" aria-haspopup="false" aria-expanded="false">
                                                    <i class="fa-solid fa-ellipsis fs-18"></i>
                                                </a>
                                                <div class="dropdown-menu dropdown-menu-end" data-popper-placement="bottom-end">
                                                    <a class="dropdown-item" href="#"><i class="las la-pen fs-16 me-1 align-text-bottom"></i> Edit</a>
                                                    <a class="dropdown-item text-danger" href="#"><i class="las la-trash fs-16 me-1 align-text-bottom"></i> Delete</a>
                                                </div>
                                            </div><!--end dropdown-->
                                            <span class="badge rounded text-info bg-info-subtle fw-normal px-1 mb-1">Medium</span>
                                            <h5 class="my-2 fs-14">Simple Design</h5>
                                            <p class="text-muted mb-3 text-truncate">Contrary to popular belief, Lorem Ipsum is not simply random text.</p>
                                            <div class="d-flex justify-content-between fw-semibold align-items-center">
                                                <p class="mb-1 d-inline-flex align-items-center"><i class="iconoir-task-list fs-18 text-muted me-1"></i>14 Tasks</p>
                                                <small class="text-end text-body-emphasis d-block ms-auto">70%</small>
                                            </div>
                                            <div class="progress bg-secondary-subtle" style="height:3px;">
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 15% " aria-valuenow="15" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 30%" aria-valuenow="30" aria-valuemin="0" aria-valuemax="100"></div>
                                                <div class="progress-bar bg-secondary rounded-pill" role="progressbar" style="margin-right:2px; width: 20%" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100"></div>
                                            </div>
                                            <hr class="hr-dashed">
                                            <div class="row justify-content-center">
                                                <div class="col-auto align-self-center">
                                                    <ul class="list-inline mb-0">
                                                        <li class="list-item d-inline-block me-2">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-file text-muted"></i>
                                                                <span class="text-muted fw-bold">5 Files</span>
                                                            </a>
                                                        </li>
                                                        <li class="list-item d-inline-block">
                                                            <a class="" href="#">
                                                                <i class="fa-regular fa-message text-muted"></i>
                                                                <span class="text-muted fw-bold">3 Comments</span>
                                                            </a>
                                                        </li>
                                                    </ul>
                                                </div><!--end col-->
                                                <div class="col align-self-center">
                                                    <div class="img-group d-flex justify-content-end">
                                                        <a class="user-avatar position-relative d-inline-block" href="#">
                                                            <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-2.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                        <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                            <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-sm shadow-sm rounded-circle">
                                                        </a>
                                                    </div>
                                                </div><!--end col-->
                                            </div><!--end row-->
                                        </div><!--end card-body-->
                                    </div><!--end card-->
                                </div><!--end project-list-left-->
                                <a href="" class="btn btn-sm btn-soft-primary w-100" data-bs-toggle="modal" data-bs-target="#addtask"> <i class="fa-solid fa-plus me-1"></i> Add New Task</a>
                            </div><!--end kanban-col-->
                        </div><!--end kanban-->
                    </div> <!--end col-->
                </div><!--end row-->
            </div><!-- container -->
            <!--Start Rightbar-->
            <?php include 'partials/endbar.php' ?>
            <!--end Rightbar-->
            <!--Start Footer-->
            <?php include 'partials/footer.php' ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->
    <div class="modal fade" id="addtask" tabindex="-1" role="dialog" aria-labelledby="addTask" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title m-0">Add New Task</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div><!--end modal-header-->
                <div class="modal-body">
                    <div class="mb-3 row">
                        <label for="inputTaskTitle1" class="col-sm-3 col-form-label text-end fw-medium">Task Title :</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="inputTaskTitle1">
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="mb-3 row">
                        <label for="inputTaskID" class="col-sm-3 col-form-label text-end fw-medium">Task ID :</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="inputTaskID">
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="mb-3 row">
                        <label for="inputAssigned" class="col-sm-3 col-form-label text-end fw-medium">Assigned to:</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="inputAssigned">
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="mb-3 row">
                        <label for="inputDescription" class="col-sm-3 col-form-label text-end fw-medium">Description:</label>
                        <div class="col-sm-9">
                            <textarea type="text" class="form-control" id="inputDescription" rows="2"></textarea>
                        </div><!--end col-->
                    </div><!--end row-->
                    <div class="row">
                        <label for="inputPriority" class="col-sm-3 col-form-label text-end fw-medium">Priority:</label>
                        <div class="col-sm-9">
                            <select class="form-select" aria-label="">
                                <option value="1" selected>Low</option>
                                <option value="2">Medium</option>
                                <option value="3">High</option>
                            </select>
                        </div><!--end col-->
                    </div><!--end row-->
                </div><!--end modal-body-->
                <div class="modal-footer">
                    <button type="button" class="btn btn-primary btn-sm">Save</button>
                    <button type="button" class="btn btn-outline-danger btn-sm" data-bs-dismiss="modal">Close</button>

                </div><!--end modal-footer-->
            </div><!--end modal-content-->
        </div><!--end modal-dialog-->
    </div><!--end modal-->

    <!-- Javascript  -->
    <!-- vendor js -->
    <?php include 'partials/vendorjs.php' ?>
    <script src="assets/libs/dragula/dragula.min.js"></script>
    <script src="assets/js/pages/project-kanban.init.js"></script>
    <script src="assets/js/app.js"></script>
</body>
<!--end body-->

</html>