<?php include 'partials/html.php' ?>

<head>
    <?php
    $title = "Avatars";
    include 'partials/title-meta.php' ?>

    <?php include 'partials/head-css.php' ?>
</head>

<body>
    <!-- Top Bar Start -->
    <?php include 'partials/topbar.php' ?>
    <!-- Top Bar End -->
    <!-- leftbar-tab-menu -->
    <?php include 'partials/startbar.php' ?>
    <!-- end leftbar-tab-menu-->

    <div class="page-wrapper">
        <!-- Page Content-->
        <div class="page-content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="page-title-box d-md-flex justify-content-md-between align-items-center">
                            <h4 class="page-title">Avatars</h4>
                            <div class="">
                                <ol class="breadcrumb mb-0">
                                    <li class="breadcrumb-item"><a href="#">Dastone</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item"><a href="#">UI Kit</a>
                                    </li><!--end nav-item-->
                                    <li class="breadcrumb-item active">Avatars</li>
                                </ol>
                            </div>
                        </div><!--end page-title-box-->
                    </div><!--end col-->
                </div><!--end row-->
                <div class="row">
                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Avatar</h4>
                                        <p class="text-muted mb-0">Single user example</p>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col">
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <img src="assets/images/users/avatar-8.jpg" alt="user" class="rounded-circle thumb-lg">
                                            </div>
                                            <div class="flex-grow-1 ms-2 text-truncate">
                                                <p class="fs-14 fw-semibold mb-0">Charles Smith</p>
                                                <p class="mb-0 fs-12 text-muted">Charles@example.com</p>
                                            </div><!--end media-body-->
                                        </div>
                                    </div><!--end col-->
                                    <div class="col-auto align-self-center">
                                        <div class="button-items">
                                            <button type="button" class="btn btn-outline-primary"><i class="fab fa-facebook-f"></i></button>
                                            <button type="button" class="btn btn-outline-info"><i class="fab fa-twitter"></i></button>
                                            <button type="button" class="btn btn-outline-pink"><i class="fab fa-dribbble"></i></button>
                                        </div>
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div><!--end col-->

                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Group Avatar</h4>
                                        <p class="text-muted mb-0">Group user example</p>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="row d-flex justify-content-center">
                                    <div class="col">
                                        <div class="img-group d-flex align-items-center">
                                            <a class="user-avatar position-relative d-inline-block" href="#">
                                                <img src="assets/images/users/avatar-1.jpg" alt="avatar" class="thumb-lg shadow-sm rounded-circle">
                                            </a>
                                            <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                <img src="assets/images/users/avatar-4.jpg" alt="avatar" class="thumb-lg shadow-sm rounded-circle">
                                            </a>
                                            <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                <img src="assets/images/users/avatar-6.jpg" alt="avatar" class="thumb-lg shadow-sm rounded-circle">
                                            </a>
                                            <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                <img src="assets/images/users/avatar-5.jpg" alt="avatar" class="thumb-lg shadow-sm rounded-circle">
                                            </a>
                                            <a class="user-avatar position-relative d-inline-block ms-n2" href="#">
                                                <img src="assets/images/users/avatar-7.jpg" alt="avatar" class="thumb-lg shadow-sm rounded-circle">
                                            </a>
                                            <a href="" class="user-avatar position-relative d-inline-block ms-1">
                                                <span class="thumb-lg shadow-sm justify-content-center d-flex align-items-center bg-soft-primary rounded-circle fw-semibold fs-6">+6</span>
                                            </a>
                                        </div>
                                    </div><!--end col-->
                                    <div class="col-auto align-self-center">
                                        <button type="button" class="btn btn-outline-light btn-sm">Message</button>
                                    </div><!--end col-->
                                </div><!--end row-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div><!--end col-->

                    <div class="col-lg-4">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Avatar With Badge</h4>
                                        <p class="text-muted mb-0">Single user with badge example</p>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="img-group d-flex">
                                    <a class="position-relative me-1" href="#">
                                        <img src="assets/images/users/avatar-10.jpg" alt="user" class="rounded-circle thumb-lg">
                                        <i class="fas fa-circle text-success fs-9 border border-white rounded-circle ms-1 position-absolute bottom-0 start-0 translate-middle"></i>
                                    </a>
                                    <a class="position-relative me-1" href="#">
                                        <img src="assets/images/users/avatar-4.jpg" alt="user" class="rounded-circle thumb-lg">
                                        <i class="fas fa-circle text-success fs-9 border border-white rounded-circle ms-1 position-absolute bottom-0 start-0 translate-middle"></i>
                                    </a>
                                    <a class="position-relative me-1" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="rounded-circle thumb-lg">
                                        <i class="fas fa-circle text-secondary fs-9 border border-white rounded-circle ms-1 position-absolute bottom-0 start-0 translate-middle"></i>
                                    </a>
                                </div><!--end img-group-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div><!--end col-->
                </div><!--end row-->
                <div class="row justify-content-center">
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Avatars Circle</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-xxl rounded-circle">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-xl rounded-circle">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-lg rounded-circle">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-md rounded-circle">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-sm rounded-circle">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-xs rounded-circle">
                                    </a>
                                </div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Avatars Square</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-xxl rounded">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-xl rounded">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-lg rounded">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-md rounded">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-sm rounded">
                                    </a>
                                    <a class="me-2 d-inline-block" href="#">
                                        <img src="assets/images/users/avatar-1.jpg" alt="user" class="thumb-xs rounded">
                                    </a>
                                </div>
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                </div><!--end row-->
                <div class="row justify-content-center">
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Text Avatars Circle</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <span class="thumb-xxl justify-content-center d-flex align-items-center bg-success-subtle text-success rounded-circle me-2">MT</span>
                                    <span class="thumb-xl justify-content-center d-flex align-items-center bg-pink-subtle text-pink rounded-circle me-2">MT</span>
                                    <span class="thumb-lg justify-content-center d-flex align-items-center bg-purple-subtle text-purple rounded-circle me-2">MT</span>
                                    <span class="thumb-md justify-content-center d-flex align-items-center bg-warning-subtle text-warning rounded-circle me-2">MT</span>
                                    <span class="thumb-sm justify-content-center d-flex align-items-center bg-info-subtle text-info rounded-circle me-2">MT</span>
                                    <span class="thumb-xs justify-content-center d-flex align-items-center bg-dark-subtle text-dark rounded-circle me-2">MT</span>
                                </div><!--end /div-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Text Avatars Square</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <span class="thumb-xxl justify-content-center d-flex align-items-center bg-success-subtle text-success rounded me-2">MT</span>
                                    <span class="thumb-xl justify-content-center d-flex align-items-center bg-pink-subtle text-pink rounded me-2">MT</span>
                                    <span class="thumb-lg justify-content-center d-flex align-items-center bg-purple-subtle text-purple rounded me-2">MT</span>
                                    <span class="thumb-md justify-content-center d-flex align-items-center bg-warning-subtle text-warning rounded me-2">MT</span>
                                    <span class="thumb-sm justify-content-center d-flex align-items-center bg-info-subtle text-info rounded me-2">MT</span>
                                    <span class="thumb-xs justify-content-center d-flex align-items-center bg-dark-subtle text-dark rounded me-2">MT</span>
                                </div><!--end /div-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                </div><!--end row-->
                <div class="row justify-content-center">
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Icon Avatars Circle</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <span class="thumb-xxl justify-content-center d-flex align-items-center bg-success text-white rounded-circle me-2">
                                        <i class="iconoir-profile-circle"></i>
                                    </span>
                                    <span class="thumb-xl justify-content-center d-flex align-items-center bg-pink text-white rounded-circle me-2">
                                        <i class="iconoir-profile-circle"></i>
                                    </span>
                                    <span class="thumb-lg justify-content-center d-flex align-items-center bg-purple text-white rounded-circle me-2">
                                        <i class="iconoir-profile-circle"></i>
                                    </span>
                                    <span class="thumb-md justify-content-center d-flex align-items-center bg-warning text-white rounded-circle me-2">
                                        <i class="iconoir-profile-circle"></i>
                                    </span>
                                    <span class="thumb-sm justify-content-center d-flex align-items-center bg-info text-white rounded-circle me-2">
                                        <i class="iconoir-profile-circle"></i>
                                    </span>
                                    <span class="thumb-xs justify-content-center d-flex align-items-center bg-dark text-white rounded-circle me-2">
                                        <i class="iconoir-profile-circle"></i>
                                    </span>
                                </div><!--end /div-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                    <div class="col-md-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="row align-items-center">
                                    <div class="col">
                                        <h4 class="card-title">Icon Avatars Square</h4>
                                    </div><!--end col-->
                                </div> <!--end row-->
                            </div><!--end card-header-->
                            <div class="card-body">
                                <div class="d-flex align-items-center">
                                    <span class="thumb-xxl justify-content-center d-flex align-items-center bg-success text-white rounded me-2">
                                        <i class="iconoir-people-tag"></i>
                                    </span>
                                    <span class="thumb-xl justify-content-center d-flex align-items-center bg-pink text-white rounded me-2">
                                        <i class="iconoir-people-tag"></i>
                                    </span>
                                    <span class="thumb-lg justify-content-center d-flex align-items-center bg-purple text-white rounded me-2">
                                        <i class="iconoir-people-tag"></i>
                                    </span>
                                    <span class="thumb-md justify-content-center d-flex align-items-center bg-warning text-white rounded me-2">
                                        <i class="iconoir-people-tag"></i>
                                    </span>
                                    <span class="thumb-sm justify-content-center d-flex align-items-center bg-info text-white rounded me-2">
                                        <i class="iconoir-people-tag"></i>
                                    </span>
                                    <span class="thumb-xs justify-content-center d-flex align-items-center bg-dark text-white rounded me-2">
                                        <i class="iconoir-people-tag"></i>
                                    </span>
                                </div><!--end /div-->
                            </div><!--end card-body-->
                        </div><!--end card-->
                    </div> <!--end col-->
                </div><!--end row-->
            </div><!-- container -->
            <!--Start Rightbar-->
            <?php include 'partials/endbar.php' ?>
            <!--end Rightbar-->
            <!--Start Footer-->
            <?php include 'partials/footer.php' ?>
            <!--end footer-->
        </div>
        <!-- end page content -->
    </div>
    <!-- end page-wrapper -->

    <!-- Javascript  -->
    <!-- vendor js -->
    <?php include 'partials/vendorjs.php' ?>

    <script src="assets/js/app.js"></script>
</body>
<!--end body-->

</html>